var prefManager = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

function getIp()
{
	var alertMe = prefManager.getBoolPref("extensions.externalip.alertMe");
	var chbAlert = document.getElementById("alert");
	chbAlert.setAttribute("checked",  alertMe);

	initIP();
	self.setTimeout('getIp()', 3600000);
}

window.addEventListener("load", getIp, false);

function initIP()
{
	var savedIP = prefManager.getCharPref("extensions.externalip.currentIP");
	var alertMe = prefManager.getBoolPref("extensions.externalip.alertMe");

	document.getElementById('alert').checked=alertMe;

	var ran=Math.round(100*Math.random());
	var address=getA(ran);

	try
	{
		xmlhttp = new XMLHttpRequest();
	}
	catch (e)
	{
		xmlhttp=false;

	}

	xmlhttp.overrideMimeType("text/xml");

	xmlhttp.open("GET", address, true);

	xmlhttp.onreadystatechange=function()
	{
		if(xmlhttp.status!="200")
		{
			return;
		}
	}

	xmlhttp.send(null);
	xmlhttp.onload = function()
	{
		xmlhttp.responseXML.getElementById('element');
		var externalIP=xmlhttp.responseText;

		externalIP = ipFromString(externalIP);

		if(validateIP(externalIP))
		{
			if(savedIP != externalIP)
			{
				if(savedIP=='notSet')
				{
					document.getElementById('externalIP-panel').label=externalIP;
					prefManager.setCharPref("extensions.externalip.currentIP",externalIP);
				}
				else
				{
					if(alertMe)
					{
						alert('Your IP address has changed! \nYour last recorded IP was: '+savedIP+'\nYour current IP is: '+externalIP);
					}
					prefManager.setCharPref("extensions.externalip.currentIP",externalIP);
					document.getElementById('externalIP-panel').label=externalIP;
				}
			}
			else
			{
				document.getElementById('externalIP-panel').label=externalIP;
			}
		}
		else
		{
			tryAgain(ran+34)
		}
	}
}



function tryAgain(ran)
{
	if(ran>100)
	 	ran=1;

	var savedIP = prefManager.getCharPref("extensions.externalip.currentIP");
	var alertMe = prefManager.getBoolPref("extensions.externalip.alertMe");

	document.getElementById('alert').checked=alertMe;

	var address=getA(ran);

	try
	{
		xmlhttp = new XMLHttpRequest();
	}
	catch (e)
	{
		xmlhttp=false;
	}

	xmlhttp.overrideMimeType("text/xml");

	xmlhttp.open("GET", address, true);

	xmlhttp.onreadystatechange=function()
	{
		if(xmlhttp.status!="200")
		{
			return;
		}
	}

	xmlhttp.send(null);
	xmlhttp.onload = function()
	{
		xmlhttp.responseXML.getElementById('element');
		var externalIP=xmlhttp.responseText;

		externalIP = ipFromString(externalIP);

		if(validateIP(externalIP))
		{
			if(savedIP != externalIP)
			{
				if(savedIP=='notSet')
				{
					document.getElementById('externalIP-panel').label=externalIP;
					prefManager.setCharPref("extensions.externalip.currentIP",externalIP);
				}
				else
				{
					if(alertMe)
					{
						alert('Your IP address has changed! \nYour last recorded IP was: '+savedIP+'\nYour current IP is: '+externalIP);
					}
					prefManager.setCharPref("extensions.externalip.currentIP",externalIP);
					document.getElementById('externalIP-panel').label=externalIP;
				}
			}
			else
			{
				document.getElementById('externalIP-panel').label=externalIP;
			}
		}
		else
		{
			document.getElementById('externalIP-panel').label='temporary error';
		}
	}
}

function update()
{
		document.getElementById('externalIP-panel').label='Checking... ';
		self.setTimeout('initIP()',800);
}


function ip2clipboard()
{
	var clipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"];
	clipboardHelper = clipboardHelper.getService(Components.interfaces.nsIClipboardHelper);
     clipboardHelper.copyString(document.getElementById('externalIP-panel').label);
}


function saveAlert(event)
{
	var menuitem = event.target;

	if (menuitem.getAttribute('checked') == 'true')
	{
		prefManager.setBoolPref("extensions.externalip.alertMe",true);
	}
	else
	{
		prefManager.setBoolPref("extensions.externalip.alertMe",false);
	}
}

function getA(i)
{
	if(i<33)
		return 'http://checkip.dyndns.com';
	else if(i<66)
		return 'http://www.mittip.nu/';
	else
		return 'http://www.crazzy.se/get_ip.php'
}

function validateIP(IP)
{
	var validIpAddress = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
	return validIpAddress.exec(IP);
}

function ipFromString(ipWithin)
{
	var regexpString=/\d\d?\d?\.\d\d?\d?\.\d\d?\d?\.\d\d?\d?/;
	var myregexp = new RegExp(regexpString);

	var match = myregexp.exec(ipWithin);

	if(match==null)
		return 'error';
	else
		return match[0];
}


function gotoURL()
{
	gBrowser.selectedTab = gBrowser.addTab("http://www.ermodev.se/visa_firefoxExtensions.htm");
}